/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import java.io.Serializable;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;

public class Date
implements Serializable {
    private int day;
    private int month;
    private int year;

    public Date() {
        this.setDate(1, 1, 1900);
    }

    public Date(int day, int month, int year) {
        this.setDate(day, month, year);
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    private boolean isLeapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        if (year % 100 == 0) {
            return false;
        }
        return year % 4 == 0;
    }

    private boolean isValid(int day, int month, int year) {
        boolean result = true;
        if (day <= 0 || day > 31 || month <= 0 || month > 12) {
            result = false;
        } else {
            switch (month) {
                case 2: {
                    if (this.isLeapYear(year)) {
                        if (day <= 29) break;
                        result = false;
                        break;
                    }
                    if (day <= 28) break;
                    result = false;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    if (day <= 30) break;
                    result = false;
                }
            }
        }
        return result;
    }

    public void setDate(int day, int month, int year) {
        if (!this.isValid(day, month, year)) {
            String msg = day + "/" + month + "/" + year;
            throw new InvalidDataException(msg);
        }
        this.day = day;
        this.month = month;
        this.year = year;
    }

    public void getDate(int[] dmy) {
        dmy[0] = this.day;
        dmy[1] = this.month;
        dmy[2] = this.year;
    }

    public boolean isEqualTo(Date obj) {
        return this.day == obj.day && this.month == obj.month && this.year == obj.year;
    }

    public boolean isGreaterThan(Date obj) {
        if (this.year > obj.year) {
            return true;
        }
        if (this.month > obj.month) {
            return true;
        }
        return this.day > obj.day;
    }

    public boolean isSmallerThan(Date obj) {
        if (this.isEqualTo(obj)) {
            return false;
        }
        return !this.isGreaterThan(obj);
    }
}

